package zio.aws.ecs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterRequest(
    clusterName: Option[String] = None,
    tags: Option[Iterable[zio.aws.ecs.model.Tag]] = None,
    settings: Option[Iterable[zio.aws.ecs.model.ClusterSetting]] = None,
    configuration: Option[zio.aws.ecs.model.ClusterConfiguration] = None,
    capacityProviders: Option[Iterable[String]] = None,
    defaultCapacityProviderStrategy: Option[
      Iterable[zio.aws.ecs.model.CapacityProviderStrategyItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ecs.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ecs.model.CreateClusterRequest
      .builder()
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        settings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.settings)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        capacityProviders.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.capacityProviders)
      .optionallyWith(
        defaultCapacityProviderStrategy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultCapacityProviderStrategy)
      .build()
  }
  def asReadOnly: zio.aws.ecs.model.CreateClusterRequest.ReadOnly =
    zio.aws.ecs.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ecs.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ecs.model.CreateClusterRequest =
      zio.aws.ecs.model.CreateClusterRequest(
        clusterName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        settings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configuration.map(value => value.asEditable),
        capacityProviders.map(value => value),
        defaultCapacityProviderStrategy.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterName: Option[String]
    def tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]]
    def settings: Option[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]]
    def configuration: Option[zio.aws.ecs.model.ClusterConfiguration.ReadOnly]
    def capacityProviders: Option[List[String]]
    def defaultCapacityProviderStrategy
        : Option[List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]]
    def getClusterName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ecs.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSettings
        : ZIO[Any, AwsError, List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] =
      AwsError.unwrapOptionField("settings", settings)
    def getConfiguration
        : ZIO[Any, AwsError, zio.aws.ecs.model.ClusterConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("configuration", configuration)
    def getCapacityProviders: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("capacityProviders", capacityProviders)
    def getDefaultCapacityProviderStrategy: ZIO[Any, AwsError, List[
      zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "defaultCapacityProviderStrategy",
      defaultCapacityProviderStrategy
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ecs.model.CreateClusterRequest
  ) extends zio.aws.ecs.model.CreateClusterRequest.ReadOnly {
    override val clusterName: Option[String] =
      scala.Option(impl.clusterName()).map(value => value: String)
    override val tags: Option[List[zio.aws.ecs.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.Tag.wrap(item)
        }.toList
      )
    override val settings
        : Option[List[zio.aws.ecs.model.ClusterSetting.ReadOnly]] = scala
      .Option(impl.settings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.ClusterSetting.wrap(item)
        }.toList
      )
    override val configuration
        : Option[zio.aws.ecs.model.ClusterConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.ecs.model.ClusterConfiguration.wrap(value))
    override val capacityProviders: Option[List[String]] = scala
      .Option(impl.capacityProviders())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val defaultCapacityProviderStrategy: Option[
      List[zio.aws.ecs.model.CapacityProviderStrategyItem.ReadOnly]
    ] = scala
      .Option(impl.defaultCapacityProviderStrategy())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ecs.model.CapacityProviderStrategyItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ecs.model.CreateClusterRequest
  ): zio.aws.ecs.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
