package zio.aws.ecs.model
import scala.jdk.CollectionConverters._
sealed trait CapacityProviderField {
  def unwrap: software.amazon.awssdk.services.ecs.model.CapacityProviderField
}
object CapacityProviderField {
  def wrap(
      value: software.amazon.awssdk.services.ecs.model.CapacityProviderField
  ): zio.aws.ecs.model.CapacityProviderField = value match {
    case software.amazon.awssdk.services.ecs.model.CapacityProviderField.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ecs.model.CapacityProviderField.TAGS =>
      val r = TAGS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ecs.model.CapacityProviderField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.CapacityProviderField =
      software.amazon.awssdk.services.ecs.model.CapacityProviderField.UNKNOWN_TO_SDK_VERSION
  }
  case object TAGS extends zio.aws.ecs.model.CapacityProviderField {
    override def unwrap
        : software.amazon.awssdk.services.ecs.model.CapacityProviderField =
      software.amazon.awssdk.services.ecs.model.CapacityProviderField.TAGS
  }
}
