package zio.aws.ec2instanceconnect
import zio.aws.ec2instanceconnect.model.SendSshPublicKeyResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.ec2instanceconnect.model.{
  SendSerialConsoleSshPublicKeyResponse,
  SendSerialConsoleSshPublicKeyRequest,
  SendSshPublicKeyResponse,
  SendSshPublicKeyRequest
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.ec2instanceconnect.{
  Ec2InstanceConnectAsyncClientBuilder,
  Ec2InstanceConnectAsyncClient
}
import scala.jdk.CollectionConverters.*
trait Ec2InstanceConnect extends AspectSupport[Ec2InstanceConnect] {
  val api: Ec2InstanceConnectAsyncClient
  def sendSSHPublicKey(
      request: zio.aws.ec2instanceconnect.model.SendSshPublicKeyRequest
  ): IO[AwsError, ReadOnly]
  def sendSerialConsoleSSHPublicKey(
      request: zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest
  ): IO[
    AwsError,
    zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse.ReadOnly
  ]
}
object Ec2InstanceConnect {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Ec2InstanceConnect] =
    customized(identity)
  def customized(
      customization: Ec2InstanceConnectAsyncClientBuilder => Ec2InstanceConnectAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Ec2InstanceConnect] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: Ec2InstanceConnectAsyncClientBuilder => Ec2InstanceConnectAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Ec2InstanceConnect] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = Ec2InstanceConnectAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      Ec2InstanceConnectAsyncClient,
      Ec2InstanceConnectAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      Ec2InstanceConnectAsyncClient,
      Ec2InstanceConnectAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new Ec2InstanceConnectImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class Ec2InstanceConnectImpl[R](
      override val api: Ec2InstanceConnectAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Ec2InstanceConnect
      with AwsServiceBase[R] {
    override val serviceName: String = "Ec2InstanceConnect"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Ec2InstanceConnectImpl[R1] =
      new Ec2InstanceConnectImpl(api, newAspect, r)
    def sendSSHPublicKey(
        request: zio.aws.ec2instanceconnect.model.SendSshPublicKeyRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[SendSshPublicKeyRequest, SendSshPublicKeyResponse](
        "sendSSHPublicKey",
        api.sendSSHPublicKey
      )(request.buildAwsValue())
        .map(zio.aws.ec2instanceconnect.model.SendSshPublicKeyResponse.wrap)
        .provideEnvironment(r)
    def sendSerialConsoleSSHPublicKey(
        request: zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest
    ): IO[
      AwsError,
      zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      SendSerialConsoleSshPublicKeyRequest,
      SendSerialConsoleSshPublicKeyResponse
    ]("sendSerialConsoleSSHPublicKey", api.sendSerialConsoleSSHPublicKey)(
      request.buildAwsValue()
    ).map(
      zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse.wrap
    ).provideEnvironment(r)
  }
  def sendSSHPublicKey(
      request: zio.aws.ec2instanceconnect.model.SendSshPublicKeyRequest
  ): ZIO[zio.aws.ec2instanceconnect.Ec2InstanceConnect, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.sendSSHPublicKey(request))
  def sendSerialConsoleSSHPublicKey(
      request: zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest
  ): ZIO[
    zio.aws.ec2instanceconnect.Ec2InstanceConnect,
    AwsError,
    zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendSerialConsoleSSHPublicKey(request))
}
