package zio.aws.ec2instanceconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ec2instanceconnect.model.primitives.{Success, RequestId}
import scala.jdk.CollectionConverters.*
final case class SendSerialConsoleSshPublicKeyResponse(
    requestId: Option[RequestId] = None,
    success: Option[Success] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse = {
    import SendSerialConsoleSshPublicKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse
      .builder()
      .optionallyWith(
        requestId.map(value => RequestId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        success.map(value => Success.unwrap(value): java.lang.Boolean)
      )(_.success)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse.ReadOnly =
    zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse
      .wrap(buildAwsValue())
}
object SendSerialConsoleSshPublicKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse =
      zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse(
        requestId.map(value => value),
        success.map(value => value)
      )
    def requestId: Option[RequestId]
    def success: Option[Success]
    def getRequestId: ZIO[Any, AwsError, RequestId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getSuccess: ZIO[Any, AwsError, Success] =
      AwsError.unwrapOptionField("success", success)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse
  ) extends zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse.ReadOnly {
    override val requestId: Option[RequestId] = scala
      .Option(impl.requestId())
      .map(value =>
        zio.aws.ec2instanceconnect.model.primitives.RequestId(value)
      )
    override val success: Option[Success] = scala
      .Option(impl.success())
      .map(value => zio.aws.ec2instanceconnect.model.primitives.Success(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse
  ): zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse.ReadOnly =
    new Wrapper(impl)
}
