package zio.aws.ec2instanceconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ec2instanceconnect.model.primitives.{
  SSHPublicKey,
  SerialPort,
  InstanceId
}
import scala.jdk.CollectionConverters.*
final case class SendSerialConsoleSshPublicKeyRequest(
    instanceId: InstanceId,
    serialPort: Option[SerialPort] = None,
    sshPublicKey: SSHPublicKey
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest = {
    import SendSerialConsoleSshPublicKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .optionallyWith(
        serialPort.map(value => SerialPort.unwrap(value): Integer)
      )(_.serialPort)
      .sshPublicKey(SSHPublicKey.unwrap(sshPublicKey): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest.ReadOnly =
    zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest
      .wrap(buildAwsValue())
}
object SendSerialConsoleSshPublicKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest =
      zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest(
        instanceId,
        serialPort.map(value => value),
        sshPublicKey
      )
    def instanceId: InstanceId
    def serialPort: Option[SerialPort]
    def sshPublicKey: SSHPublicKey
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getSerialPort: ZIO[Any, AwsError, SerialPort] =
      AwsError.unwrapOptionField("serialPort", serialPort)
    def getSshPublicKey: ZIO[Any, Nothing, SSHPublicKey] =
      ZIO.succeed(sshPublicKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest
  ) extends zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2instanceconnect.model.primitives.InstanceId(impl.instanceId())
    override val serialPort: Option[SerialPort] = scala
      .Option(impl.serialPort())
      .map(value =>
        zio.aws.ec2instanceconnect.model.primitives.SerialPort(value)
      )
    override val sshPublicKey: SSHPublicKey =
      zio.aws.ec2instanceconnect.model.primitives
        .SSHPublicKey(impl.sshPublicKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest
  ): zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest.ReadOnly =
    new Wrapper(impl)
}
