package zio.aws.ec2instanceconnect
import zio.aws.ec2instanceconnect.model.SendSshPublicKeyResponse.ReadOnly
import zio.aws.ec2instanceconnect.model.{
  SendSerialConsoleSshPublicKeyRequest,
  SendSshPublicKeyRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.ec2instanceconnect.Ec2InstanceConnectAsyncClient
import zio.test.mock.{Proxy, Mock}
object Ec2InstanceConnectMock extends Mock[Ec2InstanceConnect] {
  object SendSSHPublicKey
      extends Effect[SendSshPublicKeyRequest, AwsError, ReadOnly]
  object SendSerialConsoleSSHPublicKey
      extends Effect[
        SendSerialConsoleSshPublicKeyRequest,
        AwsError,
        zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Ec2InstanceConnect] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Ec2InstanceConnect {
          val api: Ec2InstanceConnectAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Ec2InstanceConnect = this
          def sendSSHPublicKey(
              request: SendSshPublicKeyRequest
          ): IO[AwsError, ReadOnly] = proxy(SendSSHPublicKey, request)
          def sendSerialConsoleSSHPublicKey(
              request: SendSerialConsoleSshPublicKeyRequest
          ): IO[
            AwsError,
            zio.aws.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse.ReadOnly
          ] = proxy(SendSerialConsoleSSHPublicKey, request)
        }
      }
    }
    .toLayer
}
