package zio.aws.ec2instanceconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ec2instanceconnect.model.primitives.{Success, RequestId}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SendSshPublicKeyResponse(
    requestId: Optional[RequestId] = Optional.Absent,
    success: Optional[Success] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyResponse = {
    import SendSshPublicKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyResponse
      .builder()
      .optionallyWith(
        requestId.map(value => RequestId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(
        success.map(value => Success.unwrap(value): java.lang.Boolean)
      )(_.success)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2instanceconnect.model.SendSshPublicKeyResponse.ReadOnly =
    zio.aws.ec2instanceconnect.model.SendSshPublicKeyResponse
      .wrap(buildAwsValue())
}
object SendSshPublicKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2instanceconnect.model.SendSshPublicKeyResponse =
      zio.aws.ec2instanceconnect.model.SendSshPublicKeyResponse(
        requestId.map(value => value),
        success.map(value => value)
      )
    def requestId: Optional[RequestId]
    def success: Optional[Success]
    def getRequestId: ZIO[Any, AwsError, RequestId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getSuccess: ZIO[Any, AwsError, Success] =
      AwsError.unwrapOptionField("success", success)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyResponse
  ) extends zio.aws.ec2instanceconnect.model.SendSshPublicKeyResponse.ReadOnly {
    override val requestId: Optional[RequestId] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value =>
        zio.aws.ec2instanceconnect.model.primitives.RequestId(value)
      )
    override val success: Optional[Success] = zio.aws.core.internal
      .optionalFromNullable(impl.success())
      .map(value => zio.aws.ec2instanceconnect.model.primitives.Success(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyResponse
  ): zio.aws.ec2instanceconnect.model.SendSshPublicKeyResponse.ReadOnly =
    new Wrapper(impl)
}
