package zio.aws.ec2instanceconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ec2instanceconnect.model.primitives.{
  AvailabilityZone,
  SSHPublicKey,
  InstanceOSUser,
  InstanceId
}
import scala.jdk.CollectionConverters._
final case class SendSshPublicKeyRequest(
    instanceId: InstanceId,
    instanceOSUser: InstanceOSUser,
    sshPublicKey: SSHPublicKey,
    availabilityZone: AvailabilityZone
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyRequest = {
    import SendSshPublicKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyRequest
      .builder()
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .instanceOSUser(InstanceOSUser.unwrap(instanceOSUser): java.lang.String)
      .sshPublicKey(SSHPublicKey.unwrap(sshPublicKey): java.lang.String)
      .availabilityZone(
        AvailabilityZone.unwrap(availabilityZone): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2instanceconnect.model.SendSshPublicKeyRequest.ReadOnly =
    zio.aws.ec2instanceconnect.model.SendSshPublicKeyRequest
      .wrap(buildAwsValue())
}
object SendSshPublicKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2instanceconnect.model.SendSshPublicKeyRequest =
      zio.aws.ec2instanceconnect.model.SendSshPublicKeyRequest(
        instanceId,
        instanceOSUser,
        sshPublicKey,
        availabilityZone
      )
    def instanceId: InstanceId
    def instanceOSUser: InstanceOSUser
    def sshPublicKey: SSHPublicKey
    def availabilityZone: AvailabilityZone
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
    def getInstanceOSUser: ZIO[Any, Nothing, InstanceOSUser] =
      ZIO.succeed(instanceOSUser)
    def getSshPublicKey: ZIO[Any, Nothing, SSHPublicKey] =
      ZIO.succeed(sshPublicKey)
    def getAvailabilityZone: ZIO[Any, Nothing, AvailabilityZone] =
      ZIO.succeed(availabilityZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyRequest
  ) extends zio.aws.ec2instanceconnect.model.SendSshPublicKeyRequest.ReadOnly {
    override val instanceId: InstanceId =
      zio.aws.ec2instanceconnect.model.primitives.InstanceId(impl.instanceId())
    override val instanceOSUser: InstanceOSUser =
      zio.aws.ec2instanceconnect.model.primitives
        .InstanceOSUser(impl.instanceOSUser())
    override val sshPublicKey: SSHPublicKey =
      zio.aws.ec2instanceconnect.model.primitives
        .SSHPublicKey(impl.sshPublicKey())
    override val availabilityZone: AvailabilityZone =
      zio.aws.ec2instanceconnect.model.primitives
        .AvailabilityZone(impl.availabilityZone())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyRequest
  ): zio.aws.ec2instanceconnect.model.SendSshPublicKeyRequest.ReadOnly =
    new Wrapper(impl)
}
