package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VerifiedAccessTrustProvider(
    verifiedAccessTrustProviderId: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    trustProviderType: Optional[zio.aws.ec2.model.TrustProviderType] =
      Optional.Absent,
    userTrustProviderType: Optional[zio.aws.ec2.model.UserTrustProviderType] =
      Optional.Absent,
    deviceTrustProviderType: Optional[
      zio.aws.ec2.model.DeviceTrustProviderType
    ] = Optional.Absent,
    oidcOptions: Optional[zio.aws.ec2.model.OidcOptions] = Optional.Absent,
    deviceOptions: Optional[zio.aws.ec2.model.DeviceOptions] = Optional.Absent,
    policyReferenceName: Optional[String] = Optional.Absent,
    creationTime: Optional[String] = Optional.Absent,
    lastUpdatedTime: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProvider = {
    import VerifiedAccessTrustProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProvider
      .builder()
      .optionallyWith(
        verifiedAccessTrustProviderId.map(value => value: java.lang.String)
      )(_.verifiedAccessTrustProviderId)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(trustProviderType.map(value => value.unwrap))(
        _.trustProviderType
      )
      .optionallyWith(userTrustProviderType.map(value => value.unwrap))(
        _.userTrustProviderType
      )
      .optionallyWith(deviceTrustProviderType.map(value => value.unwrap))(
        _.deviceTrustProviderType
      )
      .optionallyWith(oidcOptions.map(value => value.buildAwsValue()))(
        _.oidcOptions
      )
      .optionallyWith(deviceOptions.map(value => value.buildAwsValue()))(
        _.deviceOptions
      )
      .optionallyWith(
        policyReferenceName.map(value => value: java.lang.String)
      )(_.policyReferenceName)
      .optionallyWith(creationTime.map(value => value: java.lang.String))(
        _.creationTime
      )
      .optionallyWith(lastUpdatedTime.map(value => value: java.lang.String))(
        _.lastUpdatedTime
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(sseSpecification.map(value => value.buildAwsValue()))(
        _.sseSpecification
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly =
    zio.aws.ec2.model.VerifiedAccessTrustProvider.wrap(buildAwsValue())
}
object VerifiedAccessTrustProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VerifiedAccessTrustProvider =
      zio.aws.ec2.model.VerifiedAccessTrustProvider(
        verifiedAccessTrustProviderId.map(value => value),
        description.map(value => value),
        trustProviderType.map(value => value),
        userTrustProviderType.map(value => value),
        deviceTrustProviderType.map(value => value),
        oidcOptions.map(value => value.asEditable),
        deviceOptions.map(value => value.asEditable),
        policyReferenceName.map(value => value),
        creationTime.map(value => value),
        lastUpdatedTime.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sseSpecification.map(value => value.asEditable)
      )
    def verifiedAccessTrustProviderId: Optional[String]
    def description: Optional[String]
    def trustProviderType: Optional[zio.aws.ec2.model.TrustProviderType]
    def userTrustProviderType: Optional[zio.aws.ec2.model.UserTrustProviderType]
    def deviceTrustProviderType
        : Optional[zio.aws.ec2.model.DeviceTrustProviderType]
    def oidcOptions: Optional[zio.aws.ec2.model.OidcOptions.ReadOnly]
    def deviceOptions: Optional[zio.aws.ec2.model.DeviceOptions.ReadOnly]
    def policyReferenceName: Optional[String]
    def creationTime: Optional[String]
    def lastUpdatedTime: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ]
    def getVerifiedAccessTrustProviderId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "verifiedAccessTrustProviderId",
        verifiedAccessTrustProviderId
      )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTrustProviderType
        : ZIO[Any, AwsError, zio.aws.ec2.model.TrustProviderType] =
      AwsError.unwrapOptionField("trustProviderType", trustProviderType)
    def getUserTrustProviderType
        : ZIO[Any, AwsError, zio.aws.ec2.model.UserTrustProviderType] =
      AwsError.unwrapOptionField("userTrustProviderType", userTrustProviderType)
    def getDeviceTrustProviderType
        : ZIO[Any, AwsError, zio.aws.ec2.model.DeviceTrustProviderType] =
      AwsError.unwrapOptionField(
        "deviceTrustProviderType",
        deviceTrustProviderType
      )
    def getOidcOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.OidcOptions.ReadOnly] =
      AwsError.unwrapOptionField("oidcOptions", oidcOptions)
    def getDeviceOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.DeviceOptions.ReadOnly] =
      AwsError.unwrapOptionField("deviceOptions", deviceOptions)
    def getPolicyReferenceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policyReferenceName", policyReferenceName)
    def getCreationTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdatedTime: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getSseSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ] = AwsError.unwrapOptionField("sseSpecification", sseSpecification)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProvider
  ) extends zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly {
    override val verifiedAccessTrustProviderId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessTrustProviderId())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val trustProviderType
        : Optional[zio.aws.ec2.model.TrustProviderType] = zio.aws.core.internal
      .optionalFromNullable(impl.trustProviderType())
      .map(value => zio.aws.ec2.model.TrustProviderType.wrap(value))
    override val userTrustProviderType
        : Optional[zio.aws.ec2.model.UserTrustProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userTrustProviderType())
        .map(value => zio.aws.ec2.model.UserTrustProviderType.wrap(value))
    override val deviceTrustProviderType
        : Optional[zio.aws.ec2.model.DeviceTrustProviderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceTrustProviderType())
        .map(value => zio.aws.ec2.model.DeviceTrustProviderType.wrap(value))
    override val oidcOptions: Optional[zio.aws.ec2.model.OidcOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.oidcOptions())
        .map(value => zio.aws.ec2.model.OidcOptions.wrap(value))
    override val deviceOptions
        : Optional[zio.aws.ec2.model.DeviceOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceOptions())
        .map(value => zio.aws.ec2.model.DeviceOptions.wrap(value))
    override val policyReferenceName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policyReferenceName())
      .map(value => value: String)
    override val creationTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => value: String)
    override val lastUpdatedTime: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val sseSpecification: Optional[
      zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sseSpecification())
      .map(value =>
        zio.aws.ec2.model.VerifiedAccessSseSpecificationResponse.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProvider
  ): zio.aws.ec2.model.VerifiedAccessTrustProvider.ReadOnly = new Wrapper(impl)
}
