package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VCpuCountRangeRequest(
    min: Integer,
    max: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.VCpuCountRangeRequest = {
    import VCpuCountRangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.VCpuCountRangeRequest
      .builder()
      .min(min: java.lang.Integer)
      .optionallyWith(max.map(value => value: java.lang.Integer))(_.max)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.VCpuCountRangeRequest.ReadOnly =
    zio.aws.ec2.model.VCpuCountRangeRequest.wrap(buildAwsValue())
}
object VCpuCountRangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.VCpuCountRangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.VCpuCountRangeRequest =
      zio.aws.ec2.model.VCpuCountRangeRequest(min, max.map(value => value))
    def min: Integer
    def max: Optional[Integer]
    def getMin: ZIO[Any, Nothing, Integer] = ZIO.succeed(min)
    def getMax: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("max", max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.VCpuCountRangeRequest
  ) extends zio.aws.ec2.model.VCpuCountRangeRequest.ReadOnly {
    override val min: Integer = impl.min(): Integer
    override val max: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.max())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.VCpuCountRangeRequest
  ): zio.aws.ec2.model.VCpuCountRangeRequest.ReadOnly = new Wrapper(impl)
}
