package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransitGatewayRouteAttachment(
    resourceId: Optional[String] = Optional.Absent,
    transitGatewayAttachmentId: Optional[String] = Optional.Absent,
    resourceType: Optional[
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.TransitGatewayRouteAttachment = {
    import TransitGatewayRouteAttachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteAttachment
      .builder()
      .optionallyWith(resourceId.map(value => value: java.lang.String))(
        _.resourceId
      )
      .optionallyWith(
        transitGatewayAttachmentId.map(value => value: java.lang.String)
      )(_.transitGatewayAttachmentId)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.TransitGatewayRouteAttachment.ReadOnly =
    zio.aws.ec2.model.TransitGatewayRouteAttachment.wrap(buildAwsValue())
}
object TransitGatewayRouteAttachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.TransitGatewayRouteAttachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.TransitGatewayRouteAttachment =
      zio.aws.ec2.model.TransitGatewayRouteAttachment(
        resourceId.map(value => value),
        transitGatewayAttachmentId.map(value => value),
        resourceType.map(value => value)
      )
    def resourceId: Optional[String]
    def transitGatewayAttachmentId: Optional[String]
    def resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType]
    def getResourceId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getTransitGatewayAttachmentId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentId",
        transitGatewayAttachmentId
      )
    def getResourceType: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteAttachment
  ) extends zio.aws.ec2.model.TransitGatewayRouteAttachment.ReadOnly {
    override val resourceId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => value: String)
    override val transitGatewayAttachmentId: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayAttachmentId())
        .map(value => value: String)
    override val resourceType
        : Optional[zio.aws.ec2.model.TransitGatewayAttachmentResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayAttachmentResourceType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.TransitGatewayRouteAttachment
  ): zio.aws.ec2.model.TransitGatewayRouteAttachment.ReadOnly = new Wrapper(
    impl
  )
}
