package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcEndpointServiceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartVpcEndpointServicePrivateDnsVerificationRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    serviceId: VpcEndpointServiceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest = {
    import StartVpcEndpointServicePrivateDnsVerificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .serviceId(VpcEndpointServiceId.unwrap(serviceId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest.ReadOnly =
    zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
      .wrap(buildAwsValue())
}
object StartVpcEndpointServicePrivateDnsVerificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest =
      zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest(
        dryRun.map(value => value),
        serviceId
      )
    def dryRun: Optional[Boolean]
    def serviceId: VpcEndpointServiceId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getServiceId: ZIO[Any, Nothing, VpcEndpointServiceId] =
      ZIO.succeed(serviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
  ) extends zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val serviceId: VpcEndpointServiceId =
      zio.aws.ec2.model.primitives.VpcEndpointServiceId(impl.serviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
  ): zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest.ReadOnly =
    new Wrapper(impl)
}
