package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{MillisecondDateTime, Integer}
import scala.jdk.CollectionConverters._
final case class SnapshotInfo(
    description: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent,
    encrypted: Optional[Boolean] = Optional.Absent,
    volumeId: Optional[String] = Optional.Absent,
    state: Optional[zio.aws.ec2.model.SnapshotState] = Optional.Absent,
    volumeSize: Optional[Integer] = Optional.Absent,
    startTime: Optional[MillisecondDateTime] = Optional.Absent,
    progress: Optional[String] = Optional.Absent,
    ownerId: Optional[String] = Optional.Absent,
    snapshotId: Optional[String] = Optional.Absent,
    outpostArn: Optional[String] = Optional.Absent,
    sseType: Optional[zio.aws.ec2.model.SSEType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SnapshotInfo = {
    import SnapshotInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SnapshotInfo
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(volumeId.map(value => value: java.lang.String))(
        _.volumeId
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(volumeSize.map(value => value: java.lang.Integer))(
        _.volumeSize
      )
      .optionallyWith(
        startTime.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(progress.map(value => value: java.lang.String))(
        _.progress
      )
      .optionallyWith(ownerId.map(value => value: java.lang.String))(_.ownerId)
      .optionallyWith(snapshotId.map(value => value: java.lang.String))(
        _.snapshotId
      )
      .optionallyWith(outpostArn.map(value => value: java.lang.String))(
        _.outpostArn
      )
      .optionallyWith(sseType.map(value => value.unwrap))(_.sseType)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SnapshotInfo.ReadOnly =
    zio.aws.ec2.model.SnapshotInfo.wrap(buildAwsValue())
}
object SnapshotInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ec2.model.SnapshotInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SnapshotInfo =
      zio.aws.ec2.model.SnapshotInfo(
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        encrypted.map(value => value),
        volumeId.map(value => value),
        state.map(value => value),
        volumeSize.map(value => value),
        startTime.map(value => value),
        progress.map(value => value),
        ownerId.map(value => value),
        snapshotId.map(value => value),
        outpostArn.map(value => value),
        sseType.map(value => value)
      )
    def description: Optional[String]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def encrypted: Optional[Boolean]
    def volumeId: Optional[String]
    def state: Optional[zio.aws.ec2.model.SnapshotState]
    def volumeSize: Optional[Integer]
    def startTime: Optional[MillisecondDateTime]
    def progress: Optional[String]
    def ownerId: Optional[String]
    def snapshotId: Optional[String]
    def outpostArn: Optional[String]
    def sseType: Optional[zio.aws.ec2.model.SSEType]
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getVolumeId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("volumeId", volumeId)
    def getState: ZIO[Any, AwsError, zio.aws.ec2.model.SnapshotState] =
      AwsError.unwrapOptionField("state", state)
    def getVolumeSize: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
    def getStartTime: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getProgress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("progress", progress)
    def getOwnerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getSnapshotId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getOutpostArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("outpostArn", outpostArn)
    def getSseType: ZIO[Any, AwsError, zio.aws.ec2.model.SSEType] =
      AwsError.unwrapOptionField("sseType", sseType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotInfo
  ) extends zio.aws.ec2.model.SnapshotInfo.ReadOnly {
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
    override val encrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => value: Boolean)
    override val volumeId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeId())
      .map(value => value: String)
    override val state: Optional[zio.aws.ec2.model.SnapshotState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ec2.model.SnapshotState.wrap(value))
    override val volumeSize: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeSize())
      .map(value => value: Integer)
    override val startTime: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startTime())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val progress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.progress())
      .map(value => value: String)
    override val ownerId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => value: String)
    override val snapshotId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotId())
      .map(value => value: String)
    override val outpostArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.outpostArn())
      .map(value => value: String)
    override val sseType: Optional[zio.aws.ec2.model.SSEType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sseType())
        .map(value => zio.aws.ec2.model.SSEType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SnapshotInfo
  ): zio.aws.ec2.model.SnapshotInfo.ReadOnly = new Wrapper(impl)
}
