package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ServiceState {
  def unwrap: software.amazon.awssdk.services.ec2.model.ServiceState
}
object ServiceState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ServiceState
  ): zio.aws.ec2.model.ServiceState = value match {
    case software.amazon.awssdk.services.ec2.model.ServiceState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ServiceState.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.ec2.model.ServiceState.AVAILABLE =>
      val r = Available
      r
    case software.amazon.awssdk.services.ec2.model.ServiceState.DELETING =>
      val r = Deleting
      r
    case software.amazon.awssdk.services.ec2.model.ServiceState.DELETED =>
      val r = Deleted
      r
    case software.amazon.awssdk.services.ec2.model.ServiceState.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ServiceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ServiceState =
      software.amazon.awssdk.services.ec2.model.ServiceState.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.ec2.model.ServiceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ServiceState =
      software.amazon.awssdk.services.ec2.model.ServiceState.PENDING
  }
  case object Available extends zio.aws.ec2.model.ServiceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ServiceState =
      software.amazon.awssdk.services.ec2.model.ServiceState.AVAILABLE
  }
  case object Deleting extends zio.aws.ec2.model.ServiceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ServiceState =
      software.amazon.awssdk.services.ec2.model.ServiceState.DELETING
  }
  case object Deleted extends zio.aws.ec2.model.ServiceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ServiceState =
      software.amazon.awssdk.services.ec2.model.ServiceState.DELETED
  }
  case object Failed extends zio.aws.ec2.model.ServiceState {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ServiceState =
      software.amazon.awssdk.services.ec2.model.ServiceState.FAILED
  }
}
