package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  TransitGatewayMaxResults,
  TransitGatewayRouteTableId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchTransitGatewayRoutesRequest(
    transitGatewayRouteTableId: TransitGatewayRouteTableId,
    filters: Iterable[zio.aws.ec2.model.Filter],
    maxResults: Optional[TransitGatewayMaxResults] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest = {
    import SearchTransitGatewayRoutesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest
      .builder()
      .transitGatewayRouteTableId(
        TransitGatewayRouteTableId.unwrap(
          transitGatewayRouteTableId
        ): java.lang.String
      )
      .filters(filters.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        maxResults.map(value => TransitGatewayMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.SearchTransitGatewayRoutesRequest.ReadOnly =
    zio.aws.ec2.model.SearchTransitGatewayRoutesRequest.wrap(buildAwsValue())
}
object SearchTransitGatewayRoutesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.SearchTransitGatewayRoutesRequest =
      zio.aws.ec2.model.SearchTransitGatewayRoutesRequest(
        transitGatewayRouteTableId,
        filters.map { item =>
          item.asEditable
        },
        maxResults.map(value => value),
        dryRun.map(value => value)
      )
    def transitGatewayRouteTableId: TransitGatewayRouteTableId
    def filters: List[zio.aws.ec2.model.Filter.ReadOnly]
    def maxResults: Optional[TransitGatewayMaxResults]
    def dryRun: Optional[Boolean]
    def getTransitGatewayRouteTableId
        : ZIO[Any, Nothing, TransitGatewayRouteTableId] =
      ZIO.succeed(transitGatewayRouteTableId)
    def getFilters: ZIO[Any, Nothing, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      ZIO.succeed(filters)
    def getMaxResults: ZIO[Any, AwsError, TransitGatewayMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest
  ) extends zio.aws.ec2.model.SearchTransitGatewayRoutesRequest.ReadOnly {
    override val transitGatewayRouteTableId: TransitGatewayRouteTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayRouteTableId(impl.transitGatewayRouteTableId())
    override val filters: List[zio.aws.ec2.model.Filter.ReadOnly] = impl
      .filters()
      .asScala
      .map { item =>
        zio.aws.ec2.model.Filter.wrap(item)
      }
      .toList
    override val maxResults: Optional[TransitGatewayMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.TransitGatewayMaxResults(value)
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.SearchTransitGatewayRoutesRequest
  ): zio.aws.ec2.model.SearchTransitGatewayRoutesRequest.ReadOnly = new Wrapper(
    impl
  )
}
