package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.SnapshotId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResetSnapshotAttributeRequest(
    attribute: zio.aws.ec2.model.SnapshotAttributeName,
    snapshotId: SnapshotId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest = {
    import ResetSnapshotAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest
      .builder()
      .attribute(attribute.unwrap)
      .snapshotId(SnapshotId.unwrap(snapshotId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResetSnapshotAttributeRequest.ReadOnly =
    zio.aws.ec2.model.ResetSnapshotAttributeRequest.wrap(buildAwsValue())
}
object ResetSnapshotAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResetSnapshotAttributeRequest =
      zio.aws.ec2.model.ResetSnapshotAttributeRequest(
        attribute,
        snapshotId,
        dryRun.map(value => value)
      )
    def attribute: zio.aws.ec2.model.SnapshotAttributeName
    def snapshotId: SnapshotId
    def dryRun: Optional[Boolean]
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.ec2.model.SnapshotAttributeName] =
      ZIO.succeed(attribute)
    def getSnapshotId: ZIO[Any, Nothing, SnapshotId] = ZIO.succeed(snapshotId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest
  ) extends zio.aws.ec2.model.ResetSnapshotAttributeRequest.ReadOnly {
    override val attribute: zio.aws.ec2.model.SnapshotAttributeName =
      zio.aws.ec2.model.SnapshotAttributeName.wrap(impl.attribute())
    override val snapshotId: SnapshotId =
      zio.aws.ec2.model.primitives.SnapshotId(impl.snapshotId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResetSnapshotAttributeRequest
  ): zio.aws.ec2.model.ResetSnapshotAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
