package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResetEbsDefaultKmsKeyIdResponse(
    kmsKeyId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdResponse = {
    import ResetEbsDefaultKmsKeyIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdResponse
      .builder()
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdResponse.ReadOnly =
    zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdResponse.wrap(buildAwsValue())
}
object ResetEbsDefaultKmsKeyIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdResponse =
      zio.aws.ec2.model
        .ResetEbsDefaultKmsKeyIdResponse(kmsKeyId.map(value => value))
    def kmsKeyId: Optional[String]
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdResponse
  ) extends zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdResponse.ReadOnly {
    override val kmsKeyId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ResetEbsDefaultKmsKeyIdResponse
  ): zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdResponse.ReadOnly = new Wrapper(
    impl
  )
}
