package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RejectTransitGatewayPeeringAttachmentResponse(
    transitGatewayPeeringAttachment: Optional[
      zio.aws.ec2.model.TransitGatewayPeeringAttachment
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentResponse = {
    import RejectTransitGatewayPeeringAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentResponse
      .builder()
      .optionallyWith(
        transitGatewayPeeringAttachment.map(value => value.buildAwsValue())
      )(_.transitGatewayPeeringAttachment)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse.ReadOnly =
    zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse
      .wrap(buildAwsValue())
}
object RejectTransitGatewayPeeringAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse =
      zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse(
        transitGatewayPeeringAttachment.map(value => value.asEditable)
      )
    def transitGatewayPeeringAttachment
        : Optional[zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly]
    def getTransitGatewayPeeringAttachment: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayPeeringAttachment",
      transitGatewayPeeringAttachment
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentResponse
  ) extends zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse.ReadOnly {
    override val transitGatewayPeeringAttachment
        : Optional[zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayPeeringAttachment())
        .map(value =>
          zio.aws.ec2.model.TransitGatewayPeeringAttachment.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.RejectTransitGatewayPeeringAttachmentResponse
  ): zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
