package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkInterfaceIpv6Address(
    ipv6Address: Optional[String] = Optional.Absent,
    isPrimaryIpv6: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6Address = {
    import NetworkInterfaceIpv6Address.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6Address
      .builder()
      .optionallyWith(ipv6Address.map(value => value: java.lang.String))(
        _.ipv6Address
      )
      .optionallyWith(isPrimaryIpv6.map(value => value: java.lang.Boolean))(
        _.isPrimaryIpv6
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.NetworkInterfaceIpv6Address.ReadOnly =
    zio.aws.ec2.model.NetworkInterfaceIpv6Address.wrap(buildAwsValue())
}
object NetworkInterfaceIpv6Address {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6Address
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInterfaceIpv6Address =
      zio.aws.ec2.model.NetworkInterfaceIpv6Address(
        ipv6Address.map(value => value),
        isPrimaryIpv6.map(value => value)
      )
    def ipv6Address: Optional[String]
    def isPrimaryIpv6: Optional[Boolean]
    def getIpv6Address: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ipv6Address", ipv6Address)
    def getIsPrimaryIpv6: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isPrimaryIpv6", isPrimaryIpv6)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6Address
  ) extends zio.aws.ec2.model.NetworkInterfaceIpv6Address.ReadOnly {
    override val ipv6Address: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Address())
      .map(value => value: String)
    override val isPrimaryIpv6: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isPrimaryIpv6())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInterfaceIpv6Address
  ): zio.aws.ec2.model.NetworkInterfaceIpv6Address.ReadOnly = new Wrapper(impl)
}
