package zio.aws.ec2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NetworkInsightsAccessScopeAnalysisId,
  MillisecondDateTime,
  Integer,
  ResourceArn,
  NetworkInsightsAccessScopeId
}
import scala.jdk.CollectionConverters._
final case class NetworkInsightsAccessScopeAnalysis(
    networkInsightsAccessScopeAnalysisId: Optional[
      NetworkInsightsAccessScopeAnalysisId
    ] = Optional.Absent,
    networkInsightsAccessScopeAnalysisArn: Optional[ResourceArn] =
      Optional.Absent,
    networkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId] =
      Optional.Absent,
    status: Optional[zio.aws.ec2.model.AnalysisStatus] = Optional.Absent,
    statusMessage: Optional[String] = Optional.Absent,
    warningMessage: Optional[String] = Optional.Absent,
    startDate: Optional[MillisecondDateTime] = Optional.Absent,
    endDate: Optional[MillisecondDateTime] = Optional.Absent,
    findingsFound: Optional[zio.aws.ec2.model.FindingsFound] = Optional.Absent,
    analyzedEniCount: Optional[Integer] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ec2.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysis = {
    import NetworkInsightsAccessScopeAnalysis.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysis
      .builder()
      .optionallyWith(
        networkInsightsAccessScopeAnalysisId.map(value =>
          NetworkInsightsAccessScopeAnalysisId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeAnalysisId)
      .optionallyWith(
        networkInsightsAccessScopeAnalysisArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeAnalysisArn)
      .optionallyWith(
        networkInsightsAccessScopeId.map(value =>
          NetworkInsightsAccessScopeId.unwrap(value): java.lang.String
        )
      )(_.networkInsightsAccessScopeId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(warningMessage.map(value => value: java.lang.String))(
        _.warningMessage
      )
      .optionallyWith(
        startDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.startDate)
      .optionallyWith(
        endDate.map(value => MillisecondDateTime.unwrap(value): Instant)
      )(_.endDate)
      .optionallyWith(findingsFound.map(value => value.unwrap))(_.findingsFound)
      .optionallyWith(analyzedEniCount.map(value => value: java.lang.Integer))(
        _.analyzedEniCount
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly =
    zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.wrap(buildAwsValue())
}
object NetworkInsightsAccessScopeAnalysis {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysis
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis =
      zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis(
        networkInsightsAccessScopeAnalysisId.map(value => value),
        networkInsightsAccessScopeAnalysisArn.map(value => value),
        networkInsightsAccessScopeId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        warningMessage.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        findingsFound.map(value => value),
        analyzedEniCount.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def networkInsightsAccessScopeAnalysisId
        : Optional[NetworkInsightsAccessScopeAnalysisId]
    def networkInsightsAccessScopeAnalysisArn: Optional[ResourceArn]
    def networkInsightsAccessScopeId: Optional[NetworkInsightsAccessScopeId]
    def status: Optional[zio.aws.ec2.model.AnalysisStatus]
    def statusMessage: Optional[String]
    def warningMessage: Optional[String]
    def startDate: Optional[MillisecondDateTime]
    def endDate: Optional[MillisecondDateTime]
    def findingsFound: Optional[zio.aws.ec2.model.FindingsFound]
    def analyzedEniCount: Optional[Integer]
    def tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getNetworkInsightsAccessScopeAnalysisId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeAnalysisId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeAnalysisId",
        networkInsightsAccessScopeAnalysisId
      )
    def getNetworkInsightsAccessScopeAnalysisArn
        : ZIO[Any, AwsError, ResourceArn] = AwsError.unwrapOptionField(
      "networkInsightsAccessScopeAnalysisArn",
      networkInsightsAccessScopeAnalysisArn
    )
    def getNetworkInsightsAccessScopeId
        : ZIO[Any, AwsError, NetworkInsightsAccessScopeId] =
      AwsError.unwrapOptionField(
        "networkInsightsAccessScopeId",
        networkInsightsAccessScopeId
      )
    def getStatus: ZIO[Any, AwsError, zio.aws.ec2.model.AnalysisStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getWarningMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("warningMessage", warningMessage)
    def getStartDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, MillisecondDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getFindingsFound: ZIO[Any, AwsError, zio.aws.ec2.model.FindingsFound] =
      AwsError.unwrapOptionField("findingsFound", findingsFound)
    def getAnalyzedEniCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("analyzedEniCount", analyzedEniCount)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysis
  ) extends zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly {
    override val networkInsightsAccessScopeAnalysisId
        : Optional[NetworkInsightsAccessScopeAnalysisId] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeAnalysisId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeAnalysisId(value)
      )
    override val networkInsightsAccessScopeAnalysisArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInsightsAccessScopeAnalysisArn())
        .map(value => zio.aws.ec2.model.primitives.ResourceArn(value))
    override val networkInsightsAccessScopeId
        : Optional[NetworkInsightsAccessScopeId] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInsightsAccessScopeId())
      .map(value =>
        zio.aws.ec2.model.primitives.NetworkInsightsAccessScopeId(value)
      )
    override val status: Optional[zio.aws.ec2.model.AnalysisStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ec2.model.AnalysisStatus.wrap(value))
    override val statusMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: String)
    override val warningMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.warningMessage())
      .map(value => value: String)
    override val startDate: Optional[MillisecondDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startDate())
        .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val endDate: Optional[MillisecondDateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endDate())
      .map(value => zio.aws.ec2.model.primitives.MillisecondDateTime(value))
    override val findingsFound: Optional[zio.aws.ec2.model.FindingsFound] =
      zio.aws.core.internal
        .optionalFromNullable(impl.findingsFound())
        .map(value => zio.aws.ec2.model.FindingsFound.wrap(value))
    override val analyzedEniCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.analyzedEniCount())
      .map(value => value: Integer)
    override val tags: Optional[List[zio.aws.ec2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.NetworkInsightsAccessScopeAnalysis
  ): zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly =
    new Wrapper(impl)
}
