package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VpnGatewayId,
  CustomerGatewayId,
  TransitGatewayId,
  VpnConnectionId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpnConnectionRequest(
    vpnConnectionId: VpnConnectionId,
    transitGatewayId: Optional[TransitGatewayId] = Optional.Absent,
    customerGatewayId: Optional[CustomerGatewayId] = Optional.Absent,
    vpnGatewayId: Optional[VpnGatewayId] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest = {
    import ModifyVpnConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest
      .builder()
      .vpnConnectionId(
        VpnConnectionId.unwrap(vpnConnectionId): java.lang.String
      )
      .optionallyWith(
        transitGatewayId.map(value =>
          TransitGatewayId.unwrap(value): java.lang.String
        )
      )(_.transitGatewayId)
      .optionallyWith(
        customerGatewayId.map(value =>
          CustomerGatewayId.unwrap(value): java.lang.String
        )
      )(_.customerGatewayId)
      .optionallyWith(
        vpnGatewayId.map(value => VpnGatewayId.unwrap(value): java.lang.String)
      )(_.vpnGatewayId)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpnConnectionRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpnConnectionRequest.wrap(buildAwsValue())
}
object ModifyVpnConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpnConnectionRequest =
      zio.aws.ec2.model.ModifyVpnConnectionRequest(
        vpnConnectionId,
        transitGatewayId.map(value => value),
        customerGatewayId.map(value => value),
        vpnGatewayId.map(value => value),
        dryRun.map(value => value)
      )
    def vpnConnectionId: VpnConnectionId
    def transitGatewayId: Optional[TransitGatewayId]
    def customerGatewayId: Optional[CustomerGatewayId]
    def vpnGatewayId: Optional[VpnGatewayId]
    def dryRun: Optional[Boolean]
    def getVpnConnectionId: ZIO[Any, Nothing, VpnConnectionId] =
      ZIO.succeed(vpnConnectionId)
    def getTransitGatewayId: ZIO[Any, AwsError, TransitGatewayId] =
      AwsError.unwrapOptionField("transitGatewayId", transitGatewayId)
    def getCustomerGatewayId: ZIO[Any, AwsError, CustomerGatewayId] =
      AwsError.unwrapOptionField("customerGatewayId", customerGatewayId)
    def getVpnGatewayId: ZIO[Any, AwsError, VpnGatewayId] =
      AwsError.unwrapOptionField("vpnGatewayId", vpnGatewayId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest
  ) extends zio.aws.ec2.model.ModifyVpnConnectionRequest.ReadOnly {
    override val vpnConnectionId: VpnConnectionId =
      zio.aws.ec2.model.primitives.VpnConnectionId(impl.vpnConnectionId())
    override val transitGatewayId: Optional[TransitGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transitGatewayId())
        .map(value => zio.aws.ec2.model.primitives.TransitGatewayId(value))
    override val customerGatewayId: Optional[CustomerGatewayId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerGatewayId())
        .map(value => zio.aws.ec2.model.primitives.CustomerGatewayId(value))
    override val vpnGatewayId: Optional[VpnGatewayId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpnGatewayId())
      .map(value => zio.aws.ec2.model.primitives.VpnGatewayId(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpnConnectionRequest
  ): zio.aws.ec2.model.ModifyVpnConnectionRequest.ReadOnly = new Wrapper(impl)
}
