package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVpcTenancyRequest(
    vpcId: VpcId,
    instanceTenancy: zio.aws.ec2.model.VpcTenancy,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest = {
    import ModifyVpcTenancyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest
      .builder()
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .instanceTenancy(instanceTenancy.unwrap)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyVpcTenancyRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVpcTenancyRequest.wrap(buildAwsValue())
}
object ModifyVpcTenancyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyVpcTenancyRequest =
      zio.aws.ec2.model.ModifyVpcTenancyRequest(
        vpcId,
        instanceTenancy,
        dryRun.map(value => value)
      )
    def vpcId: VpcId
    def instanceTenancy: zio.aws.ec2.model.VpcTenancy
    def dryRun: Optional[Boolean]
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
    def getInstanceTenancy: ZIO[Any, Nothing, zio.aws.ec2.model.VpcTenancy] =
      ZIO.succeed(instanceTenancy)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest
  ) extends zio.aws.ec2.model.ModifyVpcTenancyRequest.ReadOnly {
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
    override val instanceTenancy: zio.aws.ec2.model.VpcTenancy =
      zio.aws.ec2.model.VpcTenancy.wrap(impl.instanceTenancy())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVpcTenancyRequest
  ): zio.aws.ec2.model.ModifyVpcTenancyRequest.ReadOnly = new Wrapper(impl)
}
