package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VerifiedAccessInstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyVerifiedAccessInstanceLoggingConfigurationRequest(
    verifiedAccessInstanceId: VerifiedAccessInstanceId,
    accessLogs: zio.aws.ec2.model.VerifiedAccessLogOptions,
    dryRun: Optional[Boolean] = Optional.Absent,
    clientToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest = {
    import ModifyVerifiedAccessInstanceLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest
      .builder()
      .verifiedAccessInstanceId(
        VerifiedAccessInstanceId.unwrap(
          verifiedAccessInstanceId
        ): java.lang.String
      )
      .accessLogs(accessLogs.buildAwsValue())
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object ModifyVerifiedAccessInstanceLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest =
      zio.aws.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest(
        verifiedAccessInstanceId,
        accessLogs.asEditable,
        dryRun.map(value => value),
        clientToken.map(value => value)
      )
    def verifiedAccessInstanceId: VerifiedAccessInstanceId
    def accessLogs: zio.aws.ec2.model.VerifiedAccessLogOptions.ReadOnly
    def dryRun: Optional[Boolean]
    def clientToken: Optional[String]
    def getVerifiedAccessInstanceId
        : ZIO[Any, Nothing, VerifiedAccessInstanceId] =
      ZIO.succeed(verifiedAccessInstanceId)
    def getAccessLogs: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.VerifiedAccessLogOptions.ReadOnly
    ] = ZIO.succeed(accessLogs)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest
  ) extends zio.aws.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest.ReadOnly {
    override val verifiedAccessInstanceId: VerifiedAccessInstanceId =
      zio.aws.ec2.model.primitives
        .VerifiedAccessInstanceId(impl.verifiedAccessInstanceId())
    override val accessLogs
        : zio.aws.ec2.model.VerifiedAccessLogOptions.ReadOnly =
      zio.aws.ec2.model.VerifiedAccessLogOptions.wrap(impl.accessLogs())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val clientToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest
  ): zio.aws.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
