package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{SubnetId, TransitGatewayAttachmentId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyTransitGatewayVpcAttachmentRequest(
    transitGatewayAttachmentId: TransitGatewayAttachmentId,
    addSubnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    removeSubnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    options: Optional[
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions
    ] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest = {
    import ModifyTransitGatewayVpcAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
      .builder()
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .optionallyWith(
        addSubnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.addSubnetIds)
      .optionallyWith(
        removeSubnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removeSubnetIds)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest.ReadOnly =
    zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
      .wrap(buildAwsValue())
}
object ModifyTransitGatewayVpcAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest =
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest(
        transitGatewayAttachmentId,
        addSubnetIds.map(value => value),
        removeSubnetIds.map(value => value),
        options.map(value => value.asEditable),
        dryRun.map(value => value)
      )
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def addSubnetIds: Optional[List[SubnetId]]
    def removeSubnetIds: Optional[List[SubnetId]]
    def options: Optional[
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions.ReadOnly
    ]
    def dryRun: Optional[Boolean]
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
    def getAddSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("addSubnetIds", addSubnetIds)
    def getRemoveSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("removeSubnetIds", removeSubnetIds)
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
  ) extends zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest.ReadOnly {
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
    override val addSubnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.addSubnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SubnetId(item)
        }.toList
      )
    override val removeSubnetIds: Optional[List[SubnetId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeSubnetIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.primitives.SubnetId(item)
          }.toList
        )
    override val options: Optional[
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.options())
      .map(value =>
        zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequestOptions
          .wrap(value)
      )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
  ): zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
