package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, PrefixListResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyManagedPrefixListRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    prefixListId: PrefixListResourceId,
    currentVersion: Optional[Long] = Optional.Absent,
    prefixListName: Optional[String] = Optional.Absent,
    addEntries: Optional[Iterable[zio.aws.ec2.model.AddPrefixListEntry]] =
      Optional.Absent,
    removeEntries: Optional[Iterable[zio.aws.ec2.model.RemovePrefixListEntry]] =
      Optional.Absent,
    maxEntries: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest = {
    import ModifyManagedPrefixListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .prefixListId(PrefixListResourceId.unwrap(prefixListId): java.lang.String)
      .optionallyWith(currentVersion.map(value => value: java.lang.Long))(
        _.currentVersion
      )
      .optionallyWith(prefixListName.map(value => value: java.lang.String))(
        _.prefixListName
      )
      .optionallyWith(
        addEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.addEntries)
      .optionallyWith(
        removeEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.removeEntries)
      .optionallyWith(maxEntries.map(value => value: java.lang.Integer))(
        _.maxEntries
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyManagedPrefixListRequest.ReadOnly =
    zio.aws.ec2.model.ModifyManagedPrefixListRequest.wrap(buildAwsValue())
}
object ModifyManagedPrefixListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyManagedPrefixListRequest =
      zio.aws.ec2.model.ModifyManagedPrefixListRequest(
        dryRun.map(value => value),
        prefixListId,
        currentVersion.map(value => value),
        prefixListName.map(value => value),
        addEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        removeEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxEntries.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def prefixListId: PrefixListResourceId
    def currentVersion: Optional[Long]
    def prefixListName: Optional[String]
    def addEntries
        : Optional[List[zio.aws.ec2.model.AddPrefixListEntry.ReadOnly]]
    def removeEntries
        : Optional[List[zio.aws.ec2.model.RemovePrefixListEntry.ReadOnly]]
    def maxEntries: Optional[Integer]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getPrefixListId: ZIO[Any, Nothing, PrefixListResourceId] =
      ZIO.succeed(prefixListId)
    def getCurrentVersion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getPrefixListName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("prefixListName", prefixListName)
    def getAddEntries: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AddPrefixListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("addEntries", addEntries)
    def getRemoveEntries: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.RemovePrefixListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("removeEntries", removeEntries)
    def getMaxEntries: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxEntries", maxEntries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest
  ) extends zio.aws.ec2.model.ModifyManagedPrefixListRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val prefixListId: PrefixListResourceId =
      zio.aws.ec2.model.primitives.PrefixListResourceId(impl.prefixListId())
    override val currentVersion: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: Long)
    override val prefixListName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.prefixListName())
      .map(value => value: String)
    override val addEntries
        : Optional[List[zio.aws.ec2.model.AddPrefixListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addEntries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AddPrefixListEntry.wrap(item)
          }.toList
        )
    override val removeEntries
        : Optional[List[zio.aws.ec2.model.RemovePrefixListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removeEntries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.RemovePrefixListEntry.wrap(item)
          }.toList
        )
    override val maxEntries: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxEntries())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyManagedPrefixListRequest
  ): zio.aws.ec2.model.ModifyManagedPrefixListRequest.ReadOnly = new Wrapper(
    impl
  )
}
