package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{ListImagesInRecycleBinMaxResults, ImageId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListImagesInRecycleBinRequest(
    imageIds: Optional[Iterable[ImageId]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[ListImagesInRecycleBinMaxResults] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest = {
    import ListImagesInRecycleBinRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest
      .builder()
      .optionallyWith(
        imageIds.map(value =>
          value.map { item =>
            ImageId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.imageIds)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        maxResults.map(value =>
          ListImagesInRecycleBinMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ListImagesInRecycleBinRequest.ReadOnly =
    zio.aws.ec2.model.ListImagesInRecycleBinRequest.wrap(buildAwsValue())
}
object ListImagesInRecycleBinRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ListImagesInRecycleBinRequest =
      zio.aws.ec2.model.ListImagesInRecycleBinRequest(
        imageIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        dryRun.map(value => value)
      )
    def imageIds: Optional[List[ImageId]]
    def nextToken: Optional[String]
    def maxResults: Optional[ListImagesInRecycleBinMaxResults]
    def dryRun: Optional[Boolean]
    def getImageIds: ZIO[Any, AwsError, List[ImageId]] =
      AwsError.unwrapOptionField("imageIds", imageIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, ListImagesInRecycleBinMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest
  ) extends zio.aws.ec2.model.ListImagesInRecycleBinRequest.ReadOnly {
    override val imageIds: Optional[List[ImageId]] = zio.aws.core.internal
      .optionalFromNullable(impl.imageIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ImageId(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[ListImagesInRecycleBinMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.ListImagesInRecycleBinMaxResults(value)
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ListImagesInRecycleBinRequest
  ): zio.aws.ec2.model.ListImagesInRecycleBinRequest.ReadOnly = new Wrapper(
    impl
  )
}
