package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ImdsSupportValues {
  def unwrap: software.amazon.awssdk.services.ec2.model.ImdsSupportValues
}
object ImdsSupportValues {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ImdsSupportValues
  ): zio.aws.ec2.model.ImdsSupportValues = value match {
    case software.amazon.awssdk.services.ec2.model.ImdsSupportValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ImdsSupportValues.V2_0 =>
      val r = `v2.0`
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ImdsSupportValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImdsSupportValues =
      software.amazon.awssdk.services.ec2.model.ImdsSupportValues.UNKNOWN_TO_SDK_VERSION
  }
  case object `v2.0` extends zio.aws.ec2.model.ImdsSupportValues {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ImdsSupportValues =
      software.amazon.awssdk.services.ec2.model.ImdsSupportValues.V2_0
  }
}
