package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GroupIdentifier(
    groupName: Optional[String] = Optional.Absent,
    groupId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GroupIdentifier = {
    import GroupIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GroupIdentifier
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(groupId.map(value => value: java.lang.String))(_.groupId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.GroupIdentifier.ReadOnly =
    zio.aws.ec2.model.GroupIdentifier.wrap(buildAwsValue())
}
object GroupIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GroupIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.GroupIdentifier =
      zio.aws.ec2.model.GroupIdentifier(
        groupName.map(value => value),
        groupId.map(value => value)
      )
    def groupName: Optional[String]
    def groupId: Optional[String]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupId", groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GroupIdentifier
  ) extends zio.aws.ec2.model.GroupIdentifier.ReadOnly {
    override val groupName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => value: String)
    override val groupId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.groupId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GroupIdentifier
  ): zio.aws.ec2.model.GroupIdentifier.ReadOnly = new Wrapper(impl)
}
