package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayPolicyTableAssociationsResponse(
    associations: Optional[
      Iterable[zio.aws.ec2.model.TransitGatewayPolicyTableAssociation]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse = {
    import GetTransitGatewayPolicyTableAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse.ReadOnly =
    zio.aws.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse
      .wrap(buildAwsValue())
}
object GetTransitGatewayPolicyTableAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse =
      zio.aws.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse(
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associations: Optional[
      List[zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.ReadOnly]
    ]
    def nextToken: Optional[String]
    def getAssociations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("associations", associations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse
  ) extends zio.aws.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse.ReadOnly {
    override val associations: Optional[
      List[zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.associations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TransitGatewayPolicyTableAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse
  ): zio.aws.ec2.model.GetTransitGatewayPolicyTableAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
