package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.LaunchTemplateId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FastLaunchLaunchTemplateSpecificationResponse(
    launchTemplateId: Optional[LaunchTemplateId] = Optional.Absent,
    launchTemplateName: Optional[String] = Optional.Absent,
    version: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationResponse = {
    import FastLaunchLaunchTemplateSpecificationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationResponse
      .builder()
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(launchTemplateName.map(value => value: java.lang.String))(
        _.launchTemplateName
      )
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationResponse.ReadOnly =
    zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationResponse
      .wrap(buildAwsValue())
}
object FastLaunchLaunchTemplateSpecificationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationResponse =
      zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationResponse(
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        version.map(value => value)
      )
    def launchTemplateId: Optional[LaunchTemplateId]
    def launchTemplateName: Optional[String]
    def version: Optional[String]
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationResponse
  ) extends zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationResponse.ReadOnly {
    override val launchTemplateId: Optional[LaunchTemplateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateId())
        .map(value => zio.aws.ec2.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateName())
      .map(value => value: String)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationResponse
  ): zio.aws.ec2.model.FastLaunchLaunchTemplateSpecificationResponse.ReadOnly =
    new Wrapper(impl)
}
