package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  TransitGatewayAttachmentId,
  TransitGatewayPolicyTableId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisassociateTransitGatewayPolicyTableRequest(
    transitGatewayPolicyTableId: TransitGatewayPolicyTableId,
    transitGatewayAttachmentId: TransitGatewayAttachmentId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest = {
    import DisassociateTransitGatewayPolicyTableRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest
      .builder()
      .transitGatewayPolicyTableId(
        TransitGatewayPolicyTableId.unwrap(
          transitGatewayPolicyTableId
        ): java.lang.String
      )
      .transitGatewayAttachmentId(
        TransitGatewayAttachmentId.unwrap(
          transitGatewayAttachmentId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest.ReadOnly =
    zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest
      .wrap(buildAwsValue())
}
object DisassociateTransitGatewayPolicyTableRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest =
      zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest(
        transitGatewayPolicyTableId,
        transitGatewayAttachmentId,
        dryRun.map(value => value)
      )
    def transitGatewayPolicyTableId: TransitGatewayPolicyTableId
    def transitGatewayAttachmentId: TransitGatewayAttachmentId
    def dryRun: Optional[Boolean]
    def getTransitGatewayPolicyTableId
        : ZIO[Any, Nothing, TransitGatewayPolicyTableId] =
      ZIO.succeed(transitGatewayPolicyTableId)
    def getTransitGatewayAttachmentId
        : ZIO[Any, Nothing, TransitGatewayAttachmentId] =
      ZIO.succeed(transitGatewayAttachmentId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest
  ) extends zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest.ReadOnly {
    override val transitGatewayPolicyTableId: TransitGatewayPolicyTableId =
      zio.aws.ec2.model.primitives
        .TransitGatewayPolicyTableId(impl.transitGatewayPolicyTableId())
    override val transitGatewayAttachmentId: TransitGatewayAttachmentId =
      zio.aws.ec2.model.primitives
        .TransitGatewayAttachmentId(impl.transitGatewayAttachmentId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisassociateTransitGatewayPolicyTableRequest
  ): zio.aws.ec2.model.DisassociateTransitGatewayPolicyTableRequest.ReadOnly =
    new Wrapper(impl)
}
