package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisableFastLaunchRequest(
    imageId: ImageId,
    force: Optional[Boolean] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableFastLaunchRequest = {
    import DisableFastLaunchRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableFastLaunchRequest
      .builder()
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DisableFastLaunchRequest.ReadOnly =
    zio.aws.ec2.model.DisableFastLaunchRequest.wrap(buildAwsValue())
}
object DisableFastLaunchRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableFastLaunchRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableFastLaunchRequest =
      zio.aws.ec2.model.DisableFastLaunchRequest(
        imageId,
        force.map(value => value),
        dryRun.map(value => value)
      )
    def imageId: ImageId
    def force: Optional[Boolean]
    def dryRun: Optional[Boolean]
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastLaunchRequest
  ) extends zio.aws.ec2.model.DisableFastLaunchRequest.ReadOnly {
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val force: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: Boolean)
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableFastLaunchRequest
  ): zio.aws.ec2.model.DisableFastLaunchRequest.ReadOnly = new Wrapper(impl)
}
