package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VolumeIdWithResolver,
  InstanceIdForResolver
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetachVolumeRequest(
    device: Optional[String] = Optional.Absent,
    force: Optional[Boolean] = Optional.Absent,
    instanceId: Optional[InstanceIdForResolver] = Optional.Absent,
    volumeId: VolumeIdWithResolver,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DetachVolumeRequest = {
    import DetachVolumeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DetachVolumeRequest
      .builder()
      .optionallyWith(device.map(value => value: java.lang.String))(_.device)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .optionallyWith(
        instanceId.map(value =>
          InstanceIdForResolver.unwrap(value): java.lang.String
        )
      )(_.instanceId)
      .volumeId(VolumeIdWithResolver.unwrap(volumeId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DetachVolumeRequest.ReadOnly =
    zio.aws.ec2.model.DetachVolumeRequest.wrap(buildAwsValue())
}
object DetachVolumeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DetachVolumeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DetachVolumeRequest =
      zio.aws.ec2.model.DetachVolumeRequest(
        device.map(value => value),
        force.map(value => value),
        instanceId.map(value => value),
        volumeId,
        dryRun.map(value => value)
      )
    def device: Optional[String]
    def force: Optional[Boolean]
    def instanceId: Optional[InstanceIdForResolver]
    def volumeId: VolumeIdWithResolver
    def dryRun: Optional[Boolean]
    def getDevice: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("device", device)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
    def getInstanceId: ZIO[Any, AwsError, InstanceIdForResolver] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getVolumeId: ZIO[Any, Nothing, VolumeIdWithResolver] =
      ZIO.succeed(volumeId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DetachVolumeRequest
  ) extends zio.aws.ec2.model.DetachVolumeRequest.ReadOnly {
    override val device: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.device())
      .map(value => value: String)
    override val force: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.force())
      .map(value => value: Boolean)
    override val instanceId: Optional[InstanceIdForResolver] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceId())
        .map(value => zio.aws.ec2.model.primitives.InstanceIdForResolver(value))
    override val volumeId: VolumeIdWithResolver =
      zio.aws.ec2.model.primitives.VolumeIdWithResolver(impl.volumeId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DetachVolumeRequest
  ): zio.aws.ec2.model.DetachVolumeRequest.ReadOnly = new Wrapper(impl)
}
