package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{Integer, VolumeId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVolumesModificationsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    volumeIds: Optional[Iterable[VolumeId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest = {
    import DescribeVolumesModificationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        volumeIds.map(value =>
          value.map { item =>
            VolumeId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.volumeIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVolumesModificationsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVolumesModificationsRequest.wrap(buildAwsValue())
}
object DescribeVolumesModificationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVolumesModificationsRequest =
      zio.aws.ec2.model.DescribeVolumesModificationsRequest(
        dryRun.map(value => value),
        volumeIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def volumeIds: Optional[List[VolumeId]]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def nextToken: Optional[String]
    def maxResults: Optional[Integer]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getVolumeIds: ZIO[Any, AwsError, List[VolumeId]] =
      AwsError.unwrapOptionField("volumeIds", volumeIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest
  ) extends zio.aws.ec2.model.DescribeVolumesModificationsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val volumeIds: Optional[List[VolumeId]] = zio.aws.core.internal
      .optionalFromNullable(impl.volumeIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VolumeId(item)
        }.toList
      )
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVolumesModificationsRequest
  ): zio.aws.ec2.model.DescribeVolumesModificationsRequest.ReadOnly =
    new Wrapper(impl)
}
