package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  NextToken,
  DescribeVerifiedAccessEndpointsMaxResults,
  VerifiedAccessGroupId,
  VerifiedAccessInstanceId,
  VerifiedAccessEndpointId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeVerifiedAccessEndpointsRequest(
    verifiedAccessEndpointIds: Optional[Iterable[VerifiedAccessEndpointId]] =
      Optional.Absent,
    verifiedAccessInstanceId: Optional[VerifiedAccessInstanceId] =
      Optional.Absent,
    verifiedAccessGroupId: Optional[VerifiedAccessGroupId] = Optional.Absent,
    maxResults: Optional[DescribeVerifiedAccessEndpointsMaxResults] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsRequest = {
    import DescribeVerifiedAccessEndpointsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsRequest
      .builder()
      .optionallyWith(
        verifiedAccessEndpointIds.map(value =>
          value.map { item =>
            VerifiedAccessEndpointId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.verifiedAccessEndpointIds)
      .optionallyWith(
        verifiedAccessInstanceId.map(value =>
          VerifiedAccessInstanceId.unwrap(value): java.lang.String
        )
      )(_.verifiedAccessInstanceId)
      .optionallyWith(
        verifiedAccessGroupId.map(value =>
          VerifiedAccessGroupId.unwrap(value): java.lang.String
        )
      )(_.verifiedAccessGroupId)
      .optionallyWith(
        maxResults.map(value =>
          DescribeVerifiedAccessEndpointsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVerifiedAccessEndpointsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeVerifiedAccessEndpointsRequest
      .wrap(buildAwsValue())
}
object DescribeVerifiedAccessEndpointsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVerifiedAccessEndpointsRequest =
      zio.aws.ec2.model.DescribeVerifiedAccessEndpointsRequest(
        verifiedAccessEndpointIds.map(value => value),
        verifiedAccessInstanceId.map(value => value),
        verifiedAccessGroupId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value)
      )
    def verifiedAccessEndpointIds: Optional[List[VerifiedAccessEndpointId]]
    def verifiedAccessInstanceId: Optional[VerifiedAccessInstanceId]
    def verifiedAccessGroupId: Optional[VerifiedAccessGroupId]
    def maxResults: Optional[DescribeVerifiedAccessEndpointsMaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def getVerifiedAccessEndpointIds
        : ZIO[Any, AwsError, List[VerifiedAccessEndpointId]] = AwsError
      .unwrapOptionField("verifiedAccessEndpointIds", verifiedAccessEndpointIds)
    def getVerifiedAccessInstanceId
        : ZIO[Any, AwsError, VerifiedAccessInstanceId] = AwsError
      .unwrapOptionField("verifiedAccessInstanceId", verifiedAccessInstanceId)
    def getVerifiedAccessGroupId: ZIO[Any, AwsError, VerifiedAccessGroupId] =
      AwsError.unwrapOptionField("verifiedAccessGroupId", verifiedAccessGroupId)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeVerifiedAccessEndpointsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsRequest
  ) extends zio.aws.ec2.model.DescribeVerifiedAccessEndpointsRequest.ReadOnly {
    override val verifiedAccessEndpointIds
        : Optional[List[VerifiedAccessEndpointId]] = zio.aws.core.internal
      .optionalFromNullable(impl.verifiedAccessEndpointIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.VerifiedAccessEndpointId(item)
        }.toList
      )
    override val verifiedAccessInstanceId: Optional[VerifiedAccessInstanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessInstanceId())
        .map(value =>
          zio.aws.ec2.model.primitives.VerifiedAccessInstanceId(value)
        )
    override val verifiedAccessGroupId: Optional[VerifiedAccessGroupId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessGroupId())
        .map(value => zio.aws.ec2.model.primitives.VerifiedAccessGroupId(value))
    override val maxResults
        : Optional[DescribeVerifiedAccessEndpointsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeVerifiedAccessEndpointsMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessEndpointsRequest
  ): zio.aws.ec2.model.DescribeVerifiedAccessEndpointsRequest.ReadOnly =
    new Wrapper(impl)
}
