package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  VpcId,
  DescribeStaleSecurityGroupsNextToken,
  DescribeStaleSecurityGroupsMaxResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeStaleSecurityGroupsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[DescribeStaleSecurityGroupsMaxResults] =
      Optional.Absent,
    nextToken: Optional[DescribeStaleSecurityGroupsNextToken] = Optional.Absent,
    vpcId: VpcId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest = {
    import DescribeStaleSecurityGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        maxResults.map(value =>
          DescribeStaleSecurityGroupsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          DescribeStaleSecurityGroupsNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .vpcId(VpcId.unwrap(vpcId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest.wrap(buildAwsValue())
}
object DescribeStaleSecurityGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest =
      zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest(
        dryRun.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        vpcId
      )
    def dryRun: Optional[Boolean]
    def maxResults: Optional[DescribeStaleSecurityGroupsMaxResults]
    def nextToken: Optional[DescribeStaleSecurityGroupsNextToken]
    def vpcId: VpcId
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getMaxResults
        : ZIO[Any, AwsError, DescribeStaleSecurityGroupsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, DescribeStaleSecurityGroupsNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVpcId: ZIO[Any, Nothing, VpcId] = ZIO.succeed(vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest
  ) extends zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val maxResults: Optional[DescribeStaleSecurityGroupsMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeStaleSecurityGroupsMaxResults(value)
        )
    override val nextToken: Optional[DescribeStaleSecurityGroupsNextToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextToken())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribeStaleSecurityGroupsNextToken(value)
        )
    override val vpcId: VpcId = zio.aws.ec2.model.primitives.VpcId(impl.vpcId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeStaleSecurityGroupsRequest
  ): zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
