package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{ReservedInstancesOfferingId, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReservedInstancesOfferingsRequest(
    availabilityZone: Optional[String] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    includeMarketplace: Optional[Boolean] = Optional.Absent,
    instanceType: Optional[zio.aws.ec2.model.InstanceType] = Optional.Absent,
    maxDuration: Optional[Long] = Optional.Absent,
    maxInstanceCount: Optional[Integer] = Optional.Absent,
    minDuration: Optional[Long] = Optional.Absent,
    offeringClass: Optional[zio.aws.ec2.model.OfferingClassType] =
      Optional.Absent,
    productDescription: Optional[zio.aws.ec2.model.RIProductDescription] =
      Optional.Absent,
    reservedInstancesOfferingIds: Optional[
      Iterable[ReservedInstancesOfferingId]
    ] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceTenancy: Optional[zio.aws.ec2.model.Tenancy] = Optional.Absent,
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    offeringType: Optional[zio.aws.ec2.model.OfferingTypeValues] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest = {
    import DescribeReservedInstancesOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        includeMarketplace.map(value => value: java.lang.Boolean)
      )(_.includeMarketplace)
      .optionallyWith(instanceType.map(value => value.unwrap))(_.instanceType)
      .optionallyWith(maxDuration.map(value => value: java.lang.Long))(
        _.maxDuration
      )
      .optionallyWith(maxInstanceCount.map(value => value: java.lang.Integer))(
        _.maxInstanceCount
      )
      .optionallyWith(minDuration.map(value => value: java.lang.Long))(
        _.minDuration
      )
      .optionallyWith(offeringClass.map(value => value.unwrap))(_.offeringClass)
      .optionallyWith(productDescription.map(value => value.unwrap))(
        _.productDescription
      )
      .optionallyWith(
        reservedInstancesOfferingIds.map(value =>
          value.map { item =>
            ReservedInstancesOfferingId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.reservedInstancesOfferingIds)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(instanceTenancy.map(value => value.unwrap))(
        _.instanceTenancy
      )
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(offeringType.map(value => value.unwrap))(_.offeringType)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeReservedInstancesOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest =
      zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest(
        availabilityZone.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includeMarketplace.map(value => value),
        instanceType.map(value => value),
        maxDuration.map(value => value),
        maxInstanceCount.map(value => value),
        minDuration.map(value => value),
        offeringClass.map(value => value),
        productDescription.map(value => value),
        reservedInstancesOfferingIds.map(value => value),
        dryRun.map(value => value),
        instanceTenancy.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        offeringType.map(value => value)
      )
    def availabilityZone: Optional[String]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def includeMarketplace: Optional[Boolean]
    def instanceType: Optional[zio.aws.ec2.model.InstanceType]
    def maxDuration: Optional[Long]
    def maxInstanceCount: Optional[Integer]
    def minDuration: Optional[Long]
    def offeringClass: Optional[zio.aws.ec2.model.OfferingClassType]
    def productDescription: Optional[zio.aws.ec2.model.RIProductDescription]
    def reservedInstancesOfferingIds
        : Optional[List[ReservedInstancesOfferingId]]
    def dryRun: Optional[Boolean]
    def instanceTenancy: Optional[zio.aws.ec2.model.Tenancy]
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def offeringType: Optional[zio.aws.ec2.model.OfferingTypeValues]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getIncludeMarketplace: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeMarketplace", includeMarketplace)
    def getInstanceType: ZIO[Any, AwsError, zio.aws.ec2.model.InstanceType] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getMaxDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("maxDuration", maxDuration)
    def getMaxInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxInstanceCount", maxInstanceCount)
    def getMinDuration: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("minDuration", minDuration)
    def getOfferingClass
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingClassType] =
      AwsError.unwrapOptionField("offeringClass", offeringClass)
    def getProductDescription
        : ZIO[Any, AwsError, zio.aws.ec2.model.RIProductDescription] =
      AwsError.unwrapOptionField("productDescription", productDescription)
    def getReservedInstancesOfferingIds
        : ZIO[Any, AwsError, List[ReservedInstancesOfferingId]] =
      AwsError.unwrapOptionField(
        "reservedInstancesOfferingIds",
        reservedInstancesOfferingIds
      )
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceTenancy: ZIO[Any, AwsError, zio.aws.ec2.model.Tenancy] =
      AwsError.unwrapOptionField("instanceTenancy", instanceTenancy)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOfferingType
        : ZIO[Any, AwsError, zio.aws.ec2.model.OfferingTypeValues] =
      AwsError.unwrapOptionField("offeringType", offeringType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest
  ) extends zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val includeMarketplace: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.includeMarketplace())
      .map(value => value: Boolean)
    override val instanceType: Optional[zio.aws.ec2.model.InstanceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceType())
        .map(value => zio.aws.ec2.model.InstanceType.wrap(value))
    override val maxDuration: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.maxDuration())
      .map(value => value: Long)
    override val maxInstanceCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxInstanceCount())
      .map(value => value: Integer)
    override val minDuration: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.minDuration())
      .map(value => value: Long)
    override val offeringClass: Optional[zio.aws.ec2.model.OfferingClassType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offeringClass())
        .map(value => zio.aws.ec2.model.OfferingClassType.wrap(value))
    override val productDescription
        : Optional[zio.aws.ec2.model.RIProductDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productDescription())
        .map(value => zio.aws.ec2.model.RIProductDescription.wrap(value))
    override val reservedInstancesOfferingIds
        : Optional[List[ReservedInstancesOfferingId]] = zio.aws.core.internal
      .optionalFromNullable(impl.reservedInstancesOfferingIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.ReservedInstancesOfferingId(item)
        }.toList
      )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceTenancy: Optional[zio.aws.ec2.model.Tenancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceTenancy())
        .map(value => zio.aws.ec2.model.Tenancy.wrap(value))
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val offeringType: Optional[zio.aws.ec2.model.OfferingTypeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.offeringType())
        .map(value => zio.aws.ec2.model.OfferingTypeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest
  ): zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
