package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DescribePrincipalIdFormatMaxResults
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribePrincipalIdFormatRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    resources: Optional[Iterable[String]] = Optional.Absent,
    maxResults: Optional[DescribePrincipalIdFormatMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest = {
    import DescribePrincipalIdFormatRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        maxResults.map(value =>
          DescribePrincipalIdFormatMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribePrincipalIdFormatRequest.ReadOnly =
    zio.aws.ec2.model.DescribePrincipalIdFormatRequest.wrap(buildAwsValue())
}
object DescribePrincipalIdFormatRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribePrincipalIdFormatRequest =
      zio.aws.ec2.model.DescribePrincipalIdFormatRequest(
        dryRun.map(value => value),
        resources.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def dryRun: Optional[Boolean]
    def resources: Optional[List[String]]
    def maxResults: Optional[DescribePrincipalIdFormatMaxResults]
    def nextToken: Optional[String]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getResources: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("resources", resources)
    def getMaxResults: ZIO[Any, AwsError, DescribePrincipalIdFormatMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest
  ) extends zio.aws.ec2.model.DescribePrincipalIdFormatRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val resources: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maxResults: Optional[DescribePrincipalIdFormatMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives
            .DescribePrincipalIdFormatMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribePrincipalIdFormatRequest
  ): zio.aws.ec2.model.DescribePrincipalIdFormatRequest.ReadOnly = new Wrapper(
    impl
  )
}
