package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.DescribeMovingAddressesMaxResults
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeMovingAddressesRequest(
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    maxResults: Optional[DescribeMovingAddressesMaxResults] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent,
    publicIps: Optional[Iterable[String]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest = {
    import DescribeMovingAddressesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        maxResults.map(value =>
          DescribeMovingAddressesMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        publicIps.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.publicIps)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeMovingAddressesRequest.ReadOnly =
    zio.aws.ec2.model.DescribeMovingAddressesRequest.wrap(buildAwsValue())
}
object DescribeMovingAddressesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeMovingAddressesRequest =
      zio.aws.ec2.model.DescribeMovingAddressesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dryRun.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        publicIps.map(value => value)
      )
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def dryRun: Optional[Boolean]
    def maxResults: Optional[DescribeMovingAddressesMaxResults]
    def nextToken: Optional[String]
    def publicIps: Optional[List[String]]
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getMaxResults: ZIO[Any, AwsError, DescribeMovingAddressesMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPublicIps: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("publicIps", publicIps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest
  ) extends zio.aws.ec2.model.DescribeMovingAddressesRequest.ReadOnly {
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val maxResults: Optional[DescribeMovingAddressesMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ec2.model.primitives.DescribeMovingAddressesMaxResults(value)
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val publicIps: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.publicIps())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest
  ): zio.aws.ec2.model.DescribeMovingAddressesRequest.ReadOnly = new Wrapper(
    impl
  )
}
