package zio.aws.ec2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ec2.model.primitives.{
  Ipv6PoolMaxResults,
  NextToken,
  Ipv6PoolEc2Id
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeIpv6PoolsRequest(
    poolIds: Optional[Iterable[Ipv6PoolEc2Id]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[Ipv6PoolMaxResults] = Optional.Absent,
    dryRun: Optional[Boolean] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.ec2.model.Filter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest = {
    import DescribeIpv6PoolsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest
      .builder()
      .optionallyWith(
        poolIds.map(value =>
          value.map { item =>
            Ipv6PoolEc2Id.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.poolIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => Ipv6PoolMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeIpv6PoolsRequest.ReadOnly =
    zio.aws.ec2.model.DescribeIpv6PoolsRequest.wrap(buildAwsValue())
}
object DescribeIpv6PoolsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIpv6PoolsRequest =
      zio.aws.ec2.model.DescribeIpv6PoolsRequest(
        poolIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        dryRun.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def poolIds: Optional[List[Ipv6PoolEc2Id]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[Ipv6PoolMaxResults]
    def dryRun: Optional[Boolean]
    def filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]]
    def getPoolIds: ZIO[Any, AwsError, List[Ipv6PoolEc2Id]] =
      AwsError.unwrapOptionField("poolIds", poolIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Ipv6PoolMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest
  ) extends zio.aws.ec2.model.DescribeIpv6PoolsRequest.ReadOnly {
    override val poolIds: Optional[List[Ipv6PoolEc2Id]] = zio.aws.core.internal
      .optionalFromNullable(impl.poolIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.Ipv6PoolEc2Id(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val maxResults: Optional[Ipv6PoolMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value => zio.aws.ec2.model.primitives.Ipv6PoolMaxResults(value))
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val filters: Optional[List[zio.aws.ec2.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpv6PoolsRequest
  ): zio.aws.ec2.model.DescribeIpv6PoolsRequest.ReadOnly = new Wrapper(impl)
}
