package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeIpamPoolsResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    ipamPools: Optional[Iterable[zio.aws.ec2.model.IpamPool]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse = {
    import DescribeIpamPoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        ipamPools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipamPools)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeIpamPoolsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeIpamPoolsResponse.wrap(buildAwsValue())
}
object DescribeIpamPoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeIpamPoolsResponse =
      zio.aws.ec2.model.DescribeIpamPoolsResponse(
        nextToken.map(value => value),
        ipamPools.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def ipamPools: Optional[List[zio.aws.ec2.model.IpamPool.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIpamPools
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.IpamPool.ReadOnly]] =
      AwsError.unwrapOptionField("ipamPools", ipamPools)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse
  ) extends zio.aws.ec2.model.DescribeIpamPoolsResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ec2.model.primitives.NextToken(value))
    override val ipamPools
        : Optional[List[zio.aws.ec2.model.IpamPool.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipamPools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.IpamPool.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeIpamPoolsResponse
  ): zio.aws.ec2.model.DescribeIpamPoolsResponse.ReadOnly = new Wrapper(impl)
}
