package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeInstanceAttributeRequest(
    attribute: zio.aws.ec2.model.InstanceAttributeName,
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceId: InstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest = {
    import DescribeInstanceAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest
      .builder()
      .attribute(attribute.unwrap)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceId(InstanceId.unwrap(instanceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeInstanceAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeInstanceAttributeRequest.wrap(buildAwsValue())
}
object DescribeInstanceAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeInstanceAttributeRequest =
      zio.aws.ec2.model.DescribeInstanceAttributeRequest(
        attribute,
        dryRun.map(value => value),
        instanceId
      )
    def attribute: zio.aws.ec2.model.InstanceAttributeName
    def dryRun: Optional[Boolean]
    def instanceId: InstanceId
    def getAttribute
        : ZIO[Any, Nothing, zio.aws.ec2.model.InstanceAttributeName] =
      ZIO.succeed(attribute)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceId: ZIO[Any, Nothing, InstanceId] = ZIO.succeed(instanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest
  ) extends zio.aws.ec2.model.DescribeInstanceAttributeRequest.ReadOnly {
    override val attribute: zio.aws.ec2.model.InstanceAttributeName =
      zio.aws.ec2.model.InstanceAttributeName.wrap(impl.attribute())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceId: InstanceId =
      zio.aws.ec2.model.primitives.InstanceId(impl.instanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeInstanceAttributeRequest
  ): zio.aws.ec2.model.DescribeInstanceAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
