package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.ImageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeImageAttributeRequest(
    attribute: zio.aws.ec2.model.ImageAttributeName,
    imageId: ImageId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest = {
    import DescribeImageAttributeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest
      .builder()
      .attribute(attribute.unwrap)
      .imageId(ImageId.unwrap(imageId): java.lang.String)
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeImageAttributeRequest.ReadOnly =
    zio.aws.ec2.model.DescribeImageAttributeRequest.wrap(buildAwsValue())
}
object DescribeImageAttributeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeImageAttributeRequest =
      zio.aws.ec2.model.DescribeImageAttributeRequest(
        attribute,
        imageId,
        dryRun.map(value => value)
      )
    def attribute: zio.aws.ec2.model.ImageAttributeName
    def imageId: ImageId
    def dryRun: Optional[Boolean]
    def getAttribute: ZIO[Any, Nothing, zio.aws.ec2.model.ImageAttributeName] =
      ZIO.succeed(attribute)
    def getImageId: ZIO[Any, Nothing, ImageId] = ZIO.succeed(imageId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest
  ) extends zio.aws.ec2.model.DescribeImageAttributeRequest.ReadOnly {
    override val attribute: zio.aws.ec2.model.ImageAttributeName =
      zio.aws.ec2.model.ImageAttributeName.wrap(impl.attribute())
    override val imageId: ImageId =
      zio.aws.ec2.model.primitives.ImageId(impl.imageId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeImageAttributeRequest
  ): zio.aws.ec2.model.DescribeImageAttributeRequest.ReadOnly = new Wrapper(
    impl
  )
}
