package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeCapacityBlockOfferingsResponse(
    capacityBlockOfferings: Optional[
      Iterable[zio.aws.ec2.model.CapacityBlockOffering]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsResponse = {
    import DescribeCapacityBlockOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsResponse
      .builder()
      .optionallyWith(
        capacityBlockOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.capacityBlockOfferings)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeCapacityBlockOfferingsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeCapacityBlockOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeCapacityBlockOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeCapacityBlockOfferingsResponse =
      zio.aws.ec2.model.DescribeCapacityBlockOfferingsResponse(
        capacityBlockOfferings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def capacityBlockOfferings
        : Optional[List[zio.aws.ec2.model.CapacityBlockOffering.ReadOnly]]
    def nextToken: Optional[String]
    def getCapacityBlockOfferings: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CapacityBlockOffering.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "capacityBlockOfferings",
      capacityBlockOfferings
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsResponse
  ) extends zio.aws.ec2.model.DescribeCapacityBlockOfferingsResponse.ReadOnly {
    override val capacityBlockOfferings
        : Optional[List[zio.aws.ec2.model.CapacityBlockOffering.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityBlockOfferings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.CapacityBlockOffering.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeCapacityBlockOfferingsResponse
  ): zio.aws.ec2.model.DescribeCapacityBlockOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
