package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeregisterInstanceEventNotificationAttributesRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    instanceTagAttribute: zio.aws.ec2.model.DeregisterInstanceTagAttributeRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest = {
    import DeregisterInstanceEventNotificationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .instanceTagAttribute(instanceTagAttribute.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest.ReadOnly =
    zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
      .wrap(buildAwsValue())
}
object DeregisterInstanceEventNotificationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest =
      zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest(
        dryRun.map(value => value),
        instanceTagAttribute.asEditable
      )
    def dryRun: Optional[Boolean]
    def instanceTagAttribute
        : zio.aws.ec2.model.DeregisterInstanceTagAttributeRequest.ReadOnly
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getInstanceTagAttribute: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.DeregisterInstanceTagAttributeRequest.ReadOnly
    ] = ZIO.succeed(instanceTagAttribute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
  ) extends zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val instanceTagAttribute
        : zio.aws.ec2.model.DeregisterInstanceTagAttributeRequest.ReadOnly =
      zio.aws.ec2.model.DeregisterInstanceTagAttributeRequest
        .wrap(impl.instanceTagAttribute())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
  ): zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
