package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcEndpointServiceId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVpcEndpointServiceConfigurationsRequest(
    dryRun: Optional[Boolean] = Optional.Absent,
    serviceIds: Iterable[VpcEndpointServiceId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest = {
    import DeleteVpcEndpointServiceConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
      .builder()
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .serviceIds(serviceIds.map { item =>
        VpcEndpointServiceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest.ReadOnly =
    zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
      .wrap(buildAwsValue())
}
object DeleteVpcEndpointServiceConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest =
      zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest(
        dryRun.map(value => value),
        serviceIds
      )
    def dryRun: Optional[Boolean]
    def serviceIds: List[VpcEndpointServiceId]
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
    def getServiceIds: ZIO[Any, Nothing, List[VpcEndpointServiceId]] =
      ZIO.succeed(serviceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
  ) extends zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest.ReadOnly {
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
    override val serviceIds: List[VpcEndpointServiceId] = impl
      .serviceIds()
      .asScala
      .map { item =>
        zio.aws.ec2.model.primitives.VpcEndpointServiceId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
  ): zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
