package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVerifiedAccessInstanceResponse(
    verifiedAccessInstance: Optional[zio.aws.ec2.model.VerifiedAccessInstance] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceResponse = {
    import DeleteVerifiedAccessInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceResponse
      .builder()
      .optionallyWith(
        verifiedAccessInstance.map(value => value.buildAwsValue())
      )(_.verifiedAccessInstance)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteVerifiedAccessInstanceResponse.ReadOnly =
    zio.aws.ec2.model.DeleteVerifiedAccessInstanceResponse.wrap(buildAwsValue())
}
object DeleteVerifiedAccessInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVerifiedAccessInstanceResponse =
      zio.aws.ec2.model.DeleteVerifiedAccessInstanceResponse(
        verifiedAccessInstance.map(value => value.asEditable)
      )
    def verifiedAccessInstance
        : Optional[zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly]
    def getVerifiedAccessInstance: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly
    ] = AwsError.unwrapOptionField(
      "verifiedAccessInstance",
      verifiedAccessInstance
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceResponse
  ) extends zio.aws.ec2.model.DeleteVerifiedAccessInstanceResponse.ReadOnly {
    override val verifiedAccessInstance
        : Optional[zio.aws.ec2.model.VerifiedAccessInstance.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessInstance())
        .map(value => zio.aws.ec2.model.VerifiedAccessInstance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessInstanceResponse
  ): zio.aws.ec2.model.DeleteVerifiedAccessInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
