package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteVerifiedAccessGroupResponse(
    verifiedAccessGroup: Optional[zio.aws.ec2.model.VerifiedAccessGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupResponse = {
    import DeleteVerifiedAccessGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupResponse
      .builder()
      .optionallyWith(verifiedAccessGroup.map(value => value.buildAwsValue()))(
        _.verifiedAccessGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteVerifiedAccessGroupResponse.ReadOnly =
    zio.aws.ec2.model.DeleteVerifiedAccessGroupResponse.wrap(buildAwsValue())
}
object DeleteVerifiedAccessGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteVerifiedAccessGroupResponse =
      zio.aws.ec2.model.DeleteVerifiedAccessGroupResponse(
        verifiedAccessGroup.map(value => value.asEditable)
      )
    def verifiedAccessGroup
        : Optional[zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly]
    def getVerifiedAccessGroup
        : ZIO[Any, AwsError, zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly] =
      AwsError.unwrapOptionField("verifiedAccessGroup", verifiedAccessGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupResponse
  ) extends zio.aws.ec2.model.DeleteVerifiedAccessGroupResponse.ReadOnly {
    override val verifiedAccessGroup
        : Optional[zio.aws.ec2.model.VerifiedAccessGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verifiedAccessGroup())
        .map(value => zio.aws.ec2.model.VerifiedAccessGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteVerifiedAccessGroupResponse
  ): zio.aws.ec2.model.DeleteVerifiedAccessGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
