package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TransitGatewayRouteTableAnnouncementId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTransitGatewayRouteTableAnnouncementRequest(
    transitGatewayRouteTableAnnouncementId: TransitGatewayRouteTableAnnouncementId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest = {
    import DeleteTransitGatewayRouteTableAnnouncementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest
      .builder()
      .transitGatewayRouteTableAnnouncementId(
        TransitGatewayRouteTableAnnouncementId.unwrap(
          transitGatewayRouteTableAnnouncementId
        ): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest
      .wrap(buildAwsValue())
}
object DeleteTransitGatewayRouteTableAnnouncementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest =
      zio.aws.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest(
        transitGatewayRouteTableAnnouncementId,
        dryRun.map(value => value)
      )
    def transitGatewayRouteTableAnnouncementId
        : TransitGatewayRouteTableAnnouncementId
    def dryRun: Optional[Boolean]
    def getTransitGatewayRouteTableAnnouncementId
        : ZIO[Any, Nothing, TransitGatewayRouteTableAnnouncementId] =
      ZIO.succeed(transitGatewayRouteTableAnnouncementId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest
  ) extends zio.aws.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest.ReadOnly {
    override val transitGatewayRouteTableAnnouncementId
        : TransitGatewayRouteTableAnnouncementId =
      zio.aws.ec2.model.primitives.TransitGatewayRouteTableAnnouncementId(
        impl.transitGatewayRouteTableAnnouncementId()
      )
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest
  ): zio.aws.ec2.model.DeleteTransitGatewayRouteTableAnnouncementRequest.ReadOnly =
    new Wrapper(impl)
}
