package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.TrafficMirrorFilterId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteTrafficMirrorFilterRequest(
    trafficMirrorFilterId: TrafficMirrorFilterId,
    dryRun: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest = {
    import DeleteTrafficMirrorFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest
      .builder()
      .trafficMirrorFilterId(
        TrafficMirrorFilterId.unwrap(trafficMirrorFilterId): java.lang.String
      )
      .optionallyWith(dryRun.map(value => value: java.lang.Boolean))(_.dryRun)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest.ReadOnly =
    zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest.wrap(buildAwsValue())
}
object DeleteTrafficMirrorFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest =
      zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest(
        trafficMirrorFilterId,
        dryRun.map(value => value)
      )
    def trafficMirrorFilterId: TrafficMirrorFilterId
    def dryRun: Optional[Boolean]
    def getTrafficMirrorFilterId: ZIO[Any, Nothing, TrafficMirrorFilterId] =
      ZIO.succeed(trafficMirrorFilterId)
    def getDryRun: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest
  ) extends zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest.ReadOnly {
    override val trafficMirrorFilterId: TrafficMirrorFilterId =
      zio.aws.ec2.model.primitives
        .TrafficMirrorFilterId(impl.trafficMirrorFilterId())
    override val dryRun: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DeleteTrafficMirrorFilterRequest
  ): zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest.ReadOnly = new Wrapper(
    impl
  )
}
